//Experiment - 5
//Designing of FIR filters for low pass, high pass, band pass and band reject response.

// To Design an Band Pass FIR Filter
//Filter Length =5, Order = 4
//Window = Rectangular Window

clc;
clear;
xdel(winsid());
fc1 = input("Enter Analog lower cutoff freq. in Hz=")//250
fc2 = input("Enter Analog higher cutoff freq. in Hz=")//600
fs = input("Enter Analog sampling freq. in Hz=")//2000
M = input("Enter order of filter =")//4
w1 = (2*%pi)*(fc1/fs);
w2 = (2*%pi)*(fc2/fs);
disp(w1,'Digital lower cutoff frequency in radians.cycles/samples');
disp(w2,'Digital higher cutoff frequency in radians.cycles/samples');
wc1 = w1/%pi;
wc2 = w2/%pi;
disp(wc1,'Normalized digital lower cutoff frequency in cycles/samples');
disp(wc2,'Normalized digital higher cutoff frequency in cycles/samples');
[wft,wfm,fr]=wfir('bp',M+1,[wc1/2,wc2/2],'re',[0,0]);
disp(wft,'Impulse Response of BPF FIR Filter:h[n]=');
//Plotting the Magnitude Response of HPF FIR Filter
subplot(2,1,1)
plot(2*fr,wfm)
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR BPF')
xgrid(1)
subplot(2,1,2)
plot(fr*fs,wfm)
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR BPF')
xgrid(1)